/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.statistics;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.statistics.VWSIMStatisticsTableCellRenderer;
import filenet.sim.toolkit.viewer.statistics.VWSIMUserStatPanel;
import filenet.sim.toolkit.viewer.statistics.VWSIMUserStatTableModel;
import filenet.sim.toolkit.viewer.statistics.resources.VWSIMResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableSorter;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class VWSIMUserStatTable
extends VWTable {
    protected Frame m_parentFrame = null;
    private VWSIMUserStatPanel m_userStatPanel = null;
    private boolean m_initialized = false;
    protected VWSIMUserStatTableModel m_tableModel = null;
    private VWTableSorter m_tableSorter = null;
    private VWSIMStatisticsTableCellRenderer m_renderer = null;
    protected TableColumnModel m_columnModel = null;
    private boolean m_tabSelected = false;

    public VWSIMUserStatTable(Frame parentFrame, VWSIMUserStatTableModel tableModel) {
        this(parentFrame, null, tableModel);
    }

    public VWSIMUserStatTable(Frame parentFrame, VWSIMUserStatPanel userStatPanel, VWSIMUserStatTableModel tableModel) {
        super(tableModel);
        this.m_parentFrame = parentFrame;
        this.m_userStatPanel = userStatPanel;
        this.m_tableModel = tableModel;
        this.init();
    }

    public VWSIMUserStatTable(Frame parentFrame, VWTableSorter tableSorter) {
        this(parentFrame, null, tableSorter);
    }

    public VWSIMUserStatTable(Frame parentFrame, VWSIMUserStatPanel userStatPanel, VWTableSorter tableSorter) {
        super(tableSorter);
        this.m_parentFrame = parentFrame;
        this.m_userStatPanel = userStatPanel;
        TableModel tm = null;
        this.m_tableSorter = tableSorter;
        tm = tableSorter.getModel();
        if (tm != null && tm instanceof VWSIMUserStatTableModel) {
            this.m_tableModel = (VWSIMUserStatTableModel)tm;
        }
        this.init();
    }

    public void addNotify() {
        super.addNotify();
        this.init();
    }

    private void init() {
        this.m_columnModel = this.getColumnModel();
        this.m_renderer = new VWSIMStatisticsTableCellRenderer();
        this.setShowGrid(false);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fm = this.getFontMetrics(font);
            if (this.m_tableModel != null) {
                TableColumn nameColumn = this.m_columnModel.getColumn(0);
                nameColumn.setCellRenderer(this.m_renderer);
                int width = this.getMaxStringWidth(fm, VWSIMResource.s_user_col, 0);
                if (width != 0) {
                    nameColumn.setPreferredWidth(width += 10);
                }
                TableColumn assignedColumn = this.m_columnModel.getColumn(1);
                assignedColumn.setCellRenderer(this.m_renderer);
                width = this.getStringWidth(fm, VWSIMResource.s_assigned_col);
                if (width != 0) {
                    assignedColumn.setPreferredWidth(width += 10);
                }
                TableColumn activeColumn = this.m_columnModel.getColumn(2);
                activeColumn.setCellRenderer(this.m_renderer);
                width = this.getStringWidth(fm, VWSIMResource.s_active_col);
                if (width != 0) {
                    activeColumn.setPreferredWidth(width += 10);
                }
                TableColumn completedColumn = this.m_columnModel.getColumn(3);
                completedColumn.setCellRenderer(this.m_renderer);
                width = this.getStringWidth(fm, VWSIMResource.s_completed_col);
                if (width != 0) {
                    completedColumn.setPreferredWidth(width += 10);
                }
                TableColumn costColumn = this.m_columnModel.getColumn(4);
                costColumn.setCellRenderer(this.m_renderer);
                width = this.getStringWidth(fm, VWSIMResource.s_cost_col);
                if (width != 0) {
                    costColumn.setPreferredWidth(width += 10);
                }
                TableColumn aveCostColumn = this.m_columnModel.getColumn(5);
                aveCostColumn.setCellRenderer(this.m_renderer);
                width = this.getStringWidth(fm, VWSIMResource.s_average_cost_col);
                if (width != 0) {
                    aveCostColumn.setPreferredWidth(width += 10);
                }
            }
        }
        this.m_initialized = true;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    VWSIMAnimatorDataModel getDataModel() {
        if (this.m_tableModel != null) {
            return this.m_tableModel.getDataModel();
        }
        return null;
    }

    void tabSelected(boolean selected) {
        this.m_tabSelected = selected;
    }

    private int getMaxStringWidth(FontMetrics fm, String header, int col) {
        if (fm == null) {
            return 0;
        }
        int width = 0;
        if (header != null) {
            width = fm.stringWidth(header);
        }
        if (this.m_tableModel != null) {
            String str = null;
            width = fm.stringWidth(this.m_tableModel.getColumnName(col));
            for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
                int w;
                Object obj = this.m_tableModel.getValueAt(i, col);
                if (obj == null || !(obj instanceof String) || (str = (String)obj) == null || str.length() <= 0 || (w = fm.stringWidth(str)) <= width) continue;
                width = w;
            }
        }
        return width;
    }

    private int getStringWidth(FontMetrics fm, String str) {
        if (fm == null) {
            return 0;
        }
        int width = 0;
        if (str != null) {
            width = fm.stringWidth(str);
        }
        return width;
    }

    void releaseResources() {
        this.m_parentFrame = null;
        this.m_userStatPanel = null;
        this.m_tableSorter = null;
        if (this.m_tableModel != null && this.m_columnModel != null) {
            int n = this.m_tableModel.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.m_columnModel.getColumn(i).setCellRenderer(null);
            }
        }
        this.m_tableModel = null;
        this.m_renderer = null;
        this.m_columnModel = null;
        this.removeAll();
    }
}

